import {combineReducers} from 'redux';

import {IBusesStore} from 'reducers/buses/types/IBusesStore';
import {ELoadableReducer} from 'types/common/ELoadableReducer';

import searchForm from 'reducers/buses/searchForm/reducer';
import loadableReducer from 'reducers/utils/loadableReducers/loadableReducer';

export default combineReducers<IBusesStore>({
    searchForm,
    searchSuggests: loadableReducer(ELoadableReducer.BUSES_SEARCH_SUGGESTS),
    calendar: loadableReducer(ELoadableReducer.BUSES_CALENDAR),
    previousSearches: loadableReducer(ELoadableReducer.BUSES_PREVIOUS_SEARCHES),
    context: loadableReducer(ELoadableReducer.BUSES_CONTEXT),
    search: loadableReducer(ELoadableReducer.BUSES_SEARCH),
    popularDirections: loadableReducer(
        ELoadableReducer.BUSES_POPULAR_DIRECTIONS,
    ),
    city: loadableReducer(ELoadableReducer.BUSES_CITY),
    book: loadableReducer(ELoadableReducer.BUSES_BOOK),
    directionPage: loadableReducer(ELoadableReducer.BUSES_DIRECTION_PAGE),
});
