import {ActionType, createAsyncAction} from 'typesafe-actions';

import {TContextPointType} from 'server/api/RaspApi/types/IRaspParseContextApiResponse';
import {TBusesServicePopularDirections} from 'server/services/BusesService/types/IBusesGetPopularDirectionsServiceResponse';

export interface IBusesRequestPopularDirectionsAction {
    fromId?: string;
    limit: number;
}

interface IBusesPopularDirectionsResponse {
    directions: TBusesServicePopularDirections;
    point: TContextPointType;
}

export const getPopularDirectionsActions = createAsyncAction(
    'BUSES.INDEX.REQUEST_POPULAR_DIRECTIONS',
    'BUSES.INDEX.REQUEST_POPULAR_DIRECTIONS_SUCCESS',
    'BUSES.INDEX.REQUEST_POPULAR_DIRECTIONS_FAILURE',
)<
    IBusesRequestPopularDirectionsAction,
    IBusesPopularDirectionsResponse,
    undefined
>();

const reducerActions = {
    ...getPopularDirectionsActions,
};

export type TBusesPopularDirectionsActions = ActionType<typeof reducerActions>;
