import {createReducer} from 'typesafe-actions';

import {IBusesPopularDirectionsStore} from 'reducers/buses/types/popularDirections/IBusesPopularDirectionsStore';

import {
    getPopularDirectionsActions,
    TBusesPopularDirectionsActions,
} from 'reducers/buses/popularDirections/actions';

const INITIAL_STATE: IBusesPopularDirectionsStore = {
    value: null,
    point: null,
    isLoading: false,
    isFetched: false,
    error: false,
};

export default createReducer<
    IBusesPopularDirectionsStore,
    TBusesPopularDirectionsActions
>(INITIAL_STATE)
    .handleAction(getPopularDirectionsActions.request, state => ({
        ...state,
        value: null,
        point: null,
        isLoading: true,
        isFetched: false,
        error: false,
    }))
    .handleAction(getPopularDirectionsActions.success, (state, {payload}) => ({
        ...state,
        value: payload.directions,
        point: payload.point,
        isLoading: false,
        isFetched: true,
    }))
    .handleAction(getPopularDirectionsActions.failure, state => ({
        ...state,
        value: null,
        point: null,
        isLoading: false,
        isFetched: true,
        error: true,
    }));
