import {CITY_MOSCOW_GEO_ID} from 'constants/common';
import {POPULAR_DIRECTIONS_MAX_COUNT} from 'projects/index/IndexApp/components/IndexBuses/constants';

import {Request} from '@yandex-data-ui/core/lib/types';
import {ETransport} from 'types/common/ETransport';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {getPopularDirectionsActions} from 'reducers/buses/popularDirections/actions';

import {getUserGeoLocation} from 'selectors/common/userInfoSelector';

import requestPopularDirections from 'projects/buses/utilities/api/requestPopularDirections';

import {rasp as raspProvider} from 'serviceProvider/rasp/rasp';

interface IFetchPopularDirectionsAction {
    req?: Request;
    fromId?: string;
    limit?: number;
}

export const requestPopularDirectionsThunkAction = ({
    req,
    fromId,
    limit,
}: IFetchPopularDirectionsAction): CustomThunkAction<void> => {
    return async (dispatch, getState): Promise<void> => {
        try {
            let fromKey;

            if (fromId) {
                fromKey = fromId;
            } else {
                const reduxState = getState();

                const {geoId = CITY_MOSCOW_GEO_ID} =
                    getUserGeoLocation(reduxState);

                fromKey = `c${geoId}`;
            }

            dispatch(
                getPopularDirectionsActions.request({
                    fromId: fromKey,
                    limit: limit || POPULAR_DIRECTIONS_MAX_COUNT,
                }),
            );

            const directions = await requestPopularDirections({
                req,
                fromId: fromKey,
                limit: limit || POPULAR_DIRECTIONS_MAX_COUNT,
            });

            const {from: point} = await raspProvider
                .provider(req && req.container)
                .parseContext({
                    from_key: fromKey,
                    transport: ETransport.BUS,
                });

            dispatch(
                getPopularDirectionsActions.success({
                    directions,
                    point,
                }),
            );
        } catch (error) {
            dispatch(getPopularDirectionsActions.failure());
        }
    };
};
