import {ActionType, createAction} from 'typesafe-actions';

import {IBusesStoredSearch} from 'types/buses/common/IBusesStoredSearch';
import {IBusesPreviousSearch} from 'types/buses/common/IBusesPreviousSearch';

export const requestPreviousSearchesAction = createAction(
    'BUSES.PREVIOUS_SEARCHES.REQUEST',
)<IBusesStoredSearch[]>();

interface IRequestPreviousSearchesItemSuccessAction
    extends Pick<
        IBusesPreviousSearch,
        'price' | 'times' | 'isToday' | 'timezone'
    > {
    index: number;
    when: string;
}

export const requestPreviousSearchesItemSuccessAction = createAction(
    'BUSES.PREVIOUS_SEARCHES.REQUEST_ITEM_SUCCESS',
)<IRequestPreviousSearchesItemSuccessAction>();

export const requestPreviousSearchesItemFailureAction = createAction(
    'BUSES.PREVIOUS_SEARCHES.REQUEST_ITEM_FAILURE',
)<number>();

const reducerActions = {
    requestPreviousSearchesAction,
    requestPreviousSearchesItemSuccessAction,
    requestPreviousSearchesItemFailureAction,
};

export type TBusesPreviousSearchesActions = ActionType<typeof reducerActions>;
