import {createReducer} from 'typesafe-actions';

import {IBusesPreviousSearchStore} from 'reducers/buses/types/previousSearches/IBusesPreviousSearchStore';

import {
    requestPreviousSearchesAction,
    requestPreviousSearchesItemFailureAction,
    requestPreviousSearchesItemSuccessAction,
    TBusesPreviousSearchesActions,
} from 'reducers/buses/previousSearches/actions';

const INITIAL_STATE: IBusesPreviousSearchStore[] = [];

export default createReducer<
    IBusesPreviousSearchStore[],
    TBusesPreviousSearchesActions
>(INITIAL_STATE)
    .handleAction(requestPreviousSearchesAction, (state, {payload}) => {
        return payload.map(({from, to}) => ({
            value: {
                title: `${from.popularTitle || from.title} — ${
                    to.popularTitle || to.title
                }`,
                price: null,
                when: null,
                isToday: false,
                times: [],
                timezone: '',
                fromSuggest: from,
                toSuggest: to,
            },
            isLoading: true,
            isFetched: false,
            error: false,
        }));
    })
    .handleAction(
        requestPreviousSearchesItemSuccessAction,
        (state, {payload}) => {
            return [
                ...state.slice(0, payload.index),
                {
                    value: {
                        ...state[payload.index].value,
                        times: payload.times,
                        timezone: payload.timezone,
                        price: payload.price,
                        when: payload.when,
                        isToday: payload.isToday,
                    },
                    isLoading: false,
                    isFetched: true,
                    error: false,
                },
                ...state.slice(payload.index + 1),
            ];
        },
    )
    .handleAction(
        requestPreviousSearchesItemFailureAction,
        (state, {payload: index}) => {
            return [
                ...state.slice(0, index),
                {
                    value: state[index].value,
                    isLoading: false,
                    isFetched: true,
                    error: true,
                },
                ...state.slice(index + 1),
            ];
        },
    );
