import {ActionType, createAction, createAsyncAction} from 'typesafe-actions';

import {IBusesSearchBookingInfo} from 'reducers/buses/types/search/IBusesSearchBookingInfoStore';

import {initSearchDateAction} from 'reducers/buses/search/actions';

export const getSearchBookingInfoActions = createAsyncAction(
    'BUSES.SEARCH.REQUEST_BOOKING_INFO',
    'BUSES.SEARCH.REQUEST_BOOKING_INFO_SUCCESS',
    'BUSES.SEARCH.REQUEST_BOOKING_INFO_FAILURE',
)<string, IBusesSearchBookingInfo, IBusesSearchBookingInfo>();

export const resetSearchBookingInfoAction = createAction(
    'BUSES.SEARCH.RESET_BOOKING_INFO',
)<undefined>();

const reducerActions = {
    ...getSearchBookingInfoActions,
    resetSearchBookingInfoAction,
    initSearchAction: initSearchDateAction,
};

export type TBusesSearchBookingInfoActions = ActionType<typeof reducerActions>;
