import {createReducer} from 'typesafe-actions';

import {IBusesSearchBookingInfoStore} from 'reducers/buses/types/search/IBusesSearchBookingInfoStore';

import {
    getSearchBookingInfoActions,
    resetSearchBookingInfoAction,
    TBusesSearchBookingInfoActions,
} from 'reducers/buses/search/bookingInfo/actions';
import {initSearchDateAction} from 'reducers/buses/search/actions';

const INITIAL_STATE: IBusesSearchBookingInfoStore = {
    value: null,
    isLoading: false,
    isFetched: false,
    error: false,
};

export default createReducer<
    IBusesSearchBookingInfoStore,
    TBusesSearchBookingInfoActions
>(INITIAL_STATE)
    .handleAction(getSearchBookingInfoActions.request, (state, {payload}) => ({
        ...state,
        value: {
            id: payload,
            status: null,
        },
        isLoading: true,
        isFetched: false,
        error: false,
    }))
    .handleAction(getSearchBookingInfoActions.success, (state, {payload}) => ({
        ...state,
        value: payload,
        isLoading: false,
        isFetched: true,
    }))
    .handleAction(getSearchBookingInfoActions.failure, (state, {payload}) => ({
        ...state,
        value: payload,
        isLoading: false,
        isFetched: true,
        error: true,
    }))
    .handleAction(resetSearchBookingInfoAction, () => INITIAL_STATE)
    .handleAction(initSearchDateAction, () => INITIAL_STATE);
