import {ActionType, createAction, createAsyncAction} from 'typesafe-actions';

import {TBusesCalendar} from 'types/buses/search/TBusesCalendar';

import {leaveSearchDatePageAction} from 'reducers/buses/search/actions';

export const getSearchCalendarActions = createAsyncAction(
    'BUSES.SEARCH.REQUEST_CALENDAR',
    'BUSES.SEARCH.REQUEST_CALENDAR_SUCCESS',
    'BUSES.SEARCH.REQUEST_CALENDAR_FAILURE',
)<undefined, TBusesCalendar, undefined>();

export const resetSearchCalendarAction = createAction(
    'BUSES.SEARCH.RESET_CALENDAR',
)<undefined>();

const reducerActions = {
    ...getSearchCalendarActions,
    resetSearchCalendarAction,
    leaveSearchDatePageAction,
};

export type TBusesSearchCalendarActions = ActionType<typeof reducerActions>;
