import {createReducer} from 'typesafe-actions';

import {IBusesSearchCalendarStore} from 'reducers/buses/types/search/IBusesSearchCalendarStore';

import {
    getSearchCalendarActions,
    resetSearchCalendarAction,
    TBusesSearchCalendarActions,
} from 'reducers/buses/search/calendar/actions';

const INITIAL_STATE: IBusesSearchCalendarStore = {
    value: null,
    isLoading: false,
    isFetched: false,
    error: false,
};

export default createReducer<
    IBusesSearchCalendarStore,
    TBusesSearchCalendarActions
>(INITIAL_STATE)
    .handleAction(getSearchCalendarActions.request, state => ({
        ...state,
        value: null,
        isLoading: true,
        isFetched: false,
        error: false,
    }))
    .handleAction(getSearchCalendarActions.success, (state, {payload}) => ({
        ...state,
        value: payload,
        isLoading: false,
        isFetched: true,
    }))
    .handleAction(getSearchCalendarActions.failure, state => ({
        ...state,
        value: null,
        isLoading: false,
        isFetched: true,
        error: true,
    }))
    .handleAction(resetSearchCalendarAction, () => INITIAL_STATE);
