import moment from 'moment-timezone';

import {CALENDAR_WIDTH_DAYS} from 'projects/buses/constants/calendar';

import {Request} from '@yandex-data-ui/core/lib/types';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {getSearchCalendarActions} from 'reducers/buses/search/calendar/actions';

import requestCalendar from 'projects/buses/utilities/api/requestCalendar';
import {ROBOT} from 'utilities/dateUtils/formats';

export default function requestCalendarThunkAction(
    req?: Request,
): CustomThunkAction<void> {
    return async (dispatch, getState): Promise<void> => {
        const {
            buses: {
                context: {value: context},
            },
        } = getState();

        if (!context) {
            return;
        }

        try {
            const calendar = await requestCalendar({
                req,
                fromPointKey: context.from.key,
                toPointKey: context.to.key,
                maxDate: moment()
                    .tz(context.from.timezone)
                    .add(CALENDAR_WIDTH_DAYS, 'days')
                    .format(ROBOT),
            });

            dispatch(getSearchCalendarActions.success(calendar));
        } catch (err) {
            dispatch(getSearchCalendarActions.failure());
        }
    };
}
