import {createReducer} from 'typesafe-actions';

import {IBusesSearchFiltersStore} from 'reducers/buses/types/search/IBusesSearchFiltersStore';
import {EBusesFilter} from 'types/buses/search/filters/EBusesFilter';

import {
    TBusesSearchFiltersActions,
    updateFiltersAction,
} from 'reducers/buses/search/filters/actions';

const INITIAL_STATE: IBusesSearchFiltersStore = {
    [EBusesFilter.PRICE]: null,
    [EBusesFilter.DEPARTURE_TIME]: [],
    [EBusesFilter.ARRIVAL_TIME]: [],
    [EBusesFilter.DEPARTURE_STATION]: [],
    [EBusesFilter.ARRIVAL_STATION]: [],
};

export default createReducer<
    IBusesSearchFiltersStore,
    TBusesSearchFiltersActions
>(INITIAL_STATE).handleAction(updateFiltersAction, (state, {payload}) => ({
    ...state,
    ...payload,
}));
