import {ActionType, createAsyncAction} from 'typesafe-actions';

import {IBusesSegment} from 'types/buses/search/IBusesSegment';

import {
    initSearchDateAction,
    leaveSearchDatePageAction,
    resetSearchAction,
} from 'reducers/buses/search/actions';
import {getContextActions} from 'reducers/buses/context/actions';

export const getSearchSegmentsActions = createAsyncAction(
    'BUSES.SEARCH.REQUEST_SEGMENTS',
    'BUSES.SEARCH.REQUEST_SEGMENTS_SUCCESS',
    'BUSES.SEARCH.REQUEST_SEGMENTS_FAILURE',
)<undefined, IBusesSegment[], undefined>();

const reducerActions = {
    ...getSearchSegmentsActions,
    initSearchDateAction,
    requestContextAction: getContextActions.request,
    leaveSearchDatePageAction,
    resetSearchAction,
};

export type TBusesSearchSegmentsActions = ActionType<typeof reducerActions>;
