import {createReducer} from 'typesafe-actions';

import {IBusesSearchSegmentsStore} from 'reducers/buses/types/search/IBusesSearchSegmentsStore';

import {
    getSearchSegmentsActions,
    TBusesSearchSegmentsActions,
} from 'reducers/buses/search/segments/actions';
import {
    initSearchDateAction,
    leaveSearchDatePageAction,
    resetSearchAction,
} from 'reducers/buses/search/actions';
import {getContextActions} from 'reducers/buses/context/actions';

const INITIAL_STATE: IBusesSearchSegmentsStore = {
    value: null,
    isLoading: false,
    isFetched: false,
    error: false,
};

export default createReducer<
    IBusesSearchSegmentsStore,
    TBusesSearchSegmentsActions
>(INITIAL_STATE)
    .handleAction(getSearchSegmentsActions.request, state => ({
        ...state,
        value: null,
        isLoading: true,
        isFetched: false,
        error: false,
    }))
    .handleAction(getSearchSegmentsActions.success, (state, {payload}) => ({
        ...state,
        value: payload,
        isLoading: false,
        isFetched: true,
    }))
    .handleAction(getSearchSegmentsActions.failure, state => ({
        ...state,
        value: null,
        isLoading: false,
        isFetched: true,
        error: true,
    }))
    .handleAction(initSearchDateAction, () => INITIAL_STATE)
    .handleAction(getContextActions.request, () => INITIAL_STATE)
    .handleAction(leaveSearchDatePageAction, () => INITIAL_STATE)
    .handleAction(resetSearchAction, () => INITIAL_STATE);
