import moment from 'moment';

import {Request} from '@yandex-data-ui/core/lib/types';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {getSearchSegmentsActions} from 'reducers/buses/search/segments/actions';
import updateCalendarForClosestDaysThunkAction from 'reducers/buses/search/calendar/thunk/updateCalendarForClosestDaysThunkAction';

import requestSearchSegments from 'projects/buses/utilities/api/requestSearchSegments';
import {getNow} from 'utilities/dateUtils';

import {DAYS_AROUND_SEARCH} from 'projects/buses/pages/search/components/EmptySearch/EmptySearch';

export default function requestSearchDateSegmentsThunkAction(
    req?: Request,
): CustomThunkAction<void> {
    return async (dispatch, getState): Promise<void> => {
        const {
            buses: {
                context: {value: context},
            },
        } = getState();

        if (!context) {
            return;
        }

        try {
            dispatch(getSearchSegmentsActions.request());

            const segments = await requestSearchSegments({req, context});

            if (!segments.length && context.when) {
                await dispatch(
                    updateCalendarForClosestDaysThunkAction({
                        req,
                        context,
                        calendarWidth: moment(context.when)
                            .add(DAYS_AROUND_SEARCH, 'days')
                            .diff(moment(getNow()), 'days'),
                    }),
                );
            }

            dispatch(getSearchSegmentsActions.success(segments));
        } catch (err) {
            dispatch(getSearchSegmentsActions.failure());
        }
    };
}
