import {createReducer} from 'typesafe-actions';

import {
    EBusesSortDirection,
    EBusesSortType,
} from 'types/buses/search/EBusesSortType';
import {IBusesSearchSortStore} from 'reducers/buses/types/search/IBusesSearchSortStore';

import {
    setSortAction,
    TBusesSearchSortActions,
} from 'reducers/buses/search/sort/actions';

const INITIAL_STATE: IBusesSearchSortStore = {
    type: EBusesSortType.DEPARTURE,
    direction: EBusesSortDirection.ASC,
};

export default createReducer<IBusesSearchSortStore, TBusesSearchSortActions>(
    INITIAL_STATE,
).handleAction(setSortAction, (state, {payload}) => payload);
