import {batchActions} from 'redux-batched-actions';

import {IBusesFilledContext} from 'types/buses/common/IBusesContext';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {
    setBusesSearchFormFromFieldAction,
    setBusesSearchFormStartDateFieldAction,
    setBusesSearchFormToFieldAction,
} from 'reducers/buses/searchForm/actions';

import {getPointData} from 'projects/buses/utilities/search/getPointData';

import {ESuggestSource} from 'components/SearchSuggest/SearchSuggest';

/**
 * Заполнение поисковой формы из поискового контекста
 */
export default function fillSearchFormThunkAction(
    context: IBusesFilledContext,
): CustomThunkAction<void> {
    return async (dispatch): Promise<void> => {
        const {from, to, originWhen} = context;

        dispatch(
            batchActions([
                setBusesSearchFormFromFieldAction({
                    inputValue: from.title,
                    source: ESuggestSource.SEARCH_CONTEXT,
                    selectedValue: getPointData(from),
                }),
                setBusesSearchFormToFieldAction({
                    inputValue: to.title,
                    source: ESuggestSource.SEARCH_CONTEXT,
                    selectedValue: getPointData(to),
                }),
                setBusesSearchFormStartDateFieldAction(originWhen || null),
            ]),
        );
    };
}
