import {ActionType, createAction} from 'typesafe-actions';

import {IBusesSearchFormPointField} from 'projects/buses/components/SearchForm/types';
import {WHEN_SPECIAL_VALUE} from 'types/common/When';

export const setBusesSearchFormFromFieldAction = createAction(
    'BUSES.SEARCH_FORM.SET_FROM',
)<IBusesSearchFormPointField>();
export const setBusesSearchFormToFieldAction = createAction(
    'BUSES.SEARCH_FORM.SET_TO',
)<IBusesSearchFormPointField>();
export const setBusesSearchFormStartDateFieldAction = createAction(
    'BUSES.SEARCH_FORM.SET_START_DATE',
)<WHEN_SPECIAL_VALUE | string | null>();

const reducerActions = {
    setBusesSearchFormFromFieldAction,
    setBusesSearchFormToFieldAction,
    setBusesSearchFormStartDateFieldAction,
};

export type TBusesSearchFormActions = ActionType<typeof reducerActions>;
