import {createReducer} from 'typesafe-actions';

import {ESearchFormFieldName} from 'components/SearchForm/types';
import {IBusesSearchFormValues} from 'projects/buses/components/SearchForm/types';

import {
    setBusesSearchFormFromFieldAction,
    setBusesSearchFormStartDateFieldAction,
    setBusesSearchFormToFieldAction,
    TBusesSearchFormActions,
} from 'reducers/buses/searchForm/actions';

import {ESuggestSource} from 'components/SearchSuggest/SearchSuggest';

const INITIAL_STATE: IBusesSearchFormValues = {
    [ESearchFormFieldName.FROM]: {
        selectedValue: false,
        inputValue: '',
        source: ESuggestSource.INPUT,
    },
    [ESearchFormFieldName.TO]: {
        selectedValue: false,
        inputValue: '',
        source: ESuggestSource.INPUT,
    },
    [ESearchFormFieldName.START_DATE]: null,
};

export default createReducer<IBusesSearchFormValues, TBusesSearchFormActions>(
    INITIAL_STATE,
)
    .handleAction(setBusesSearchFormFromFieldAction, (state, {payload}) => ({
        ...state,
        [ESearchFormFieldName.FROM]: payload,
    }))
    .handleAction(setBusesSearchFormToFieldAction, (state, {payload}) => ({
        ...state,
        [ESearchFormFieldName.TO]: payload,
    }))
    .handleAction(
        setBusesSearchFormStartDateFieldAction,
        (state, {payload}) => ({
            ...state,
            [ESearchFormFieldName.START_DATE]: payload,
        }),
    );
