import {ActionType, createAsyncAction} from 'typesafe-actions';

import {IBusesSuggest} from 'types/buses/common/IBusesSuggest';
import {ESearchFormFieldName} from 'components/SearchForm/types';

export interface IGetSearchSuggestsRequestAction {
    part: string;
    clientCity: string;
    otherPoint: string;
}

export const getSearchSuggestsActions = createAsyncAction(
    'common/buses/searchSuggestsRequest',
    'common/buses/searchSuggestsRequestSuccess',
    'common/buses/searchSuggestsRequestFailure',
)<
    {
        fieldType: ESearchFormFieldName.FROM | ESearchFormFieldName.TO;
        requestParams: IGetSearchSuggestsRequestAction;
    },
    {
        fieldType: ESearchFormFieldName.FROM | ESearchFormFieldName.TO;
        items: IBusesSuggest[];
    },
    {
        fieldType: ESearchFormFieldName.FROM | ESearchFormFieldName.TO;
    }
>();

const reducerActions = {
    ...getSearchSuggestsActions,
};

export type TBusesSearchSuggestsActions = ActionType<typeof reducerActions>;
