import {createReducer} from 'typesafe-actions';

import {IBusesSuggest} from 'types/buses/common/IBusesSuggest';
import {TAsyncStore} from 'reducers/types/TAsyncStore';
import {ESearchFormFieldName} from 'components/SearchForm/types';

import {
    getSearchSuggestsActions,
    IGetSearchSuggestsRequestAction,
    TBusesSearchSuggestsActions,
} from 'reducers/buses/searchSuggests/actions';

export interface IBusesSearchSuggestsStore {
    [ESearchFormFieldName.FROM]: TAsyncStore<
        IBusesSuggest[],
        IGetSearchSuggestsRequestAction
    >;
    [ESearchFormFieldName.TO]: TAsyncStore<
        IBusesSuggest[],
        IGetSearchSuggestsRequestAction
    >;
}

const defaultFieldValue: TAsyncStore<
    IBusesSuggest[],
    TBusesSearchSuggestsActions
> = {
    value: null,
    isLoading: false,
    isNotFound: false,
    requestParams: null,
    isFailed: false,
    isFetched: false,
};

const INITIAL_STATE = {
    [ESearchFormFieldName.FROM]: defaultFieldValue,
    [ESearchFormFieldName.TO]: defaultFieldValue,
};

export default createReducer<
    IBusesSearchSuggestsStore,
    TBusesSearchSuggestsActions
>(INITIAL_STATE)
    .handleAction(
        getSearchSuggestsActions.request,
        (state, {payload: {fieldType, requestParams}}) => ({
            ...state,
            [fieldType]: {
                value: null,
                requestParams,
                isLoading: true,
                isFetched: false,
                isFailed: false,
                isNotFound: false,
            },
        }),
    )
    .handleAction(getSearchSuggestsActions.success, (state, {payload}) => {
        return {
            ...state,
            [payload.fieldType]: {
                ...state[payload.fieldType],
                value: payload.items,
                isLoading: false,
                isFetched: true,
            },
        };
    })
    .handleAction(getSearchSuggestsActions.failure, (state, {payload}) => ({
        ...state,
        [payload.fieldType]: {
            ...state[payload.fieldType],
            isLoading: false,
            isFetched: true,
            isFailed: true,
        },
    }));
