import {createAsyncAction, ActionType} from 'typesafe-actions';

import {TOrderIdType} from './types';
import {TCreateOrderAuthorizationRequestParams} from 'server/api/OrdersAPI/types/ICreateOrderAuthorization';
import {ICheckOrderAuthorizationResponse} from 'server/api/OrdersAPI/types/ICheckOrderAuthorization';

/* Check Authorization */

export const checkOrderAuthorizationActions = createAsyncAction(
    'common/checkOrderAuthorization/check',
    'common/checkOrderAuthorization/check/success',
    'common/checkOrderAuthorization/check/error',
)<
    TOrderIdType,
    ICheckOrderAuthorizationResponse,
    ICheckOrderAuthorizationResponse | null
>();

export type TCheckOrderAuthorizationActionsType = ActionType<
    typeof checkOrderAuthorizationActions
>;

export type TStartCheckOrderActionType = (
    payload: TOrderIdType,
) => TCheckOrderAuthorizationActionsType;

/* Create Authorization */

export const createOrderAuthorizationActions = createAsyncAction(
    'common/checkOrderAuthorization/create',
    'common/checkOrderAuthorization/create/success',
    'common/checkOrderAuthorization/create/error',
)<TCreateOrderAuthorizationRequestParams, undefined, undefined>();

export type TCreateOrderAuthorizationActionsType = ActionType<
    typeof createOrderAuthorizationActions
>;

export type TStartCreateOrderActionType = (
    payload: TCreateOrderAuthorizationRequestParams,
) => TCreateOrderAuthorizationActionsType;
