import {getType} from 'typesafe-actions';

import {ICheckOrderAuthorizationResponse} from 'server/api/OrdersAPI/types/ICheckOrderAuthorization';

import {
    checkOrderAuthorizationActions,
    TCheckOrderAuthorizationActionsType,
    createOrderAuthorizationActions,
    TCreateOrderAuthorizationActionsType,
} from './actions';

export interface IOrderAuthorization {
    readonly checkAuthorization: {
        isSuccess: boolean;
        isError: boolean;
        isLoading: boolean;
        orderIds: ICheckOrderAuthorizationResponse | null;
    };
    readonly createAuthorization: {
        isSuccess: boolean;
        isError: boolean;
        isLoading: boolean;
    };
}

/* Initial State */

const initialState: IOrderAuthorization = {
    checkAuthorization: {
        isSuccess: false,
        isError: false,
        isLoading: false,
        orderIds: null,
    },
    createAuthorization: {
        isSuccess: false,
        isError: false,
        isLoading: false,
    },
};

/* Reducer */

export default (
    state: IOrderAuthorization = initialState,
    action:
        | TCheckOrderAuthorizationActionsType
        | TCreateOrderAuthorizationActionsType,
): IOrderAuthorization => {
    switch (action.type) {
        /* Check Authorization */

        case getType(checkOrderAuthorizationActions.request): {
            return {
                ...initialState,
                checkAuthorization: {
                    ...initialState.checkAuthorization,
                    isLoading: true,
                },
            };
        }

        case getType(checkOrderAuthorizationActions.success): {
            const {payload} = action;

            return {
                ...state,
                checkAuthorization: {
                    ...initialState.checkAuthorization,
                    orderIds: payload,
                    isSuccess: true,
                },
            };
        }

        case getType(checkOrderAuthorizationActions.failure): {
            const {payload} = action;

            return {
                ...state,
                checkAuthorization: {
                    ...initialState.checkAuthorization,
                    orderIds: payload
                        ? payload
                        : initialState.checkAuthorization.orderIds,
                    isError: true,
                },
            };
        }

        /* Create Authorization */

        case getType(createOrderAuthorizationActions.request): {
            return {
                ...state,
                createAuthorization: {
                    ...initialState.createAuthorization,
                    isLoading: true,
                },
            };
        }

        case getType(createOrderAuthorizationActions.success): {
            return {
                ...state,
                createAuthorization: {
                    ...initialState.createAuthorization,
                    isSuccess: true,
                },
            };
        }

        case getType(createOrderAuthorizationActions.failure): {
            return {
                ...state,
                createAuthorization: {
                    ...initialState.createAuthorization,
                    isError: true,
                },
            };
        }

        default: {
            return state;
        }
    }
};
