import {ActionType} from 'typesafe-actions';

import {TLD} from 'constants/tld';

import {IUserSplit, TExperiments} from 'server/providers/experiments/types';
import {
    IBlackboxNotAuthUserInfo,
    IBlackboxAuthUserInfo,
    IUserPlusInfo,
} from 'types/common/userInfo/TBlackboxUserInfo';
import {TCommonTogglersStore} from 'types/common/togglers/TCommonTogglersStore';
import {TMetrikaGoal} from 'utilities/metrika/types/goals/all';
import {TGeoId} from 'types/TGeoId';
import {IAppVersion} from './appVersion/types';
import {IPreviousSearchFormStore} from 'reducers/common/previousSearchForm/types';
import {IWhiteLabelConfig} from 'types/common/whiteLabel/IWhiteLabelConfig';

import {
    FeatureKeyType,
    FeatureValueType,
} from 'reducers/common/features/propTypes';
import * as timeActions from 'reducers/common/time/actions';
import {FetchTokenActionType} from 'reducers/common/csrfToken/actions';
import {
    SetUserUnreadMailCountActionType,
    FetchUserUnreadMailCountActionType,
} from 'reducers/common/userUnreadMailCount/actions';
import {IOrderAuthorization} from 'reducers/common/checkOrderAuthorization/reducer';
import {ICSRFToken} from 'reducers/common/csrfToken/reducer';
import {ICurrenciesStore} from 'reducers/common/currencies/reducer';
import {IBannersState} from 'reducers/common/banners/reducer';
import {CountriesStateType} from 'reducers/common/countries/reducer';
import {IPassengersReducer} from 'reducers/common/passengers/reducer';
import {ICrossLinksState} from 'reducers/common/crossLinks/reducer';
import {IHotelsGeolocationErrorModal} from 'reducers/common/hotelsGeolocationErrorModal/reducer';
import {IPageInfo} from 'reducers/common/page/reducer';
import {ISnackbarState} from 'reducers/common/snackbar/reducer';
import {TSubscriptionStore} from 'reducers/common/subscription/rootReducer';

export type TCommonAction =
    | FetchTokenActionType
    | SetUserUnreadMailCountActionType
    | FetchUserUnreadMailCountActionType
    | ActionType<typeof timeActions>;

export type FeaturesState = Partial<Record<FeatureKeyType, FeatureValueType>>;

export interface IDeviceOS {
    name: string;
    version: string;
}

export interface IDeviceBrowser {
    name: string;
    version: string;
}

export interface IDevice {
    isMobile: boolean;
    isTouch: boolean;
    isDesktop: boolean;
    /** @deprecated - после отказа от IE флаг больше не нужен */
    isIe: boolean;
    os: IDeviceOS;
    browser: IDeviceBrowser;
}

export interface IGeoLocation {
    geoName?: string;
    geoNameEn?: string;
    geoId?: TGeoId;
    countryId?: number;
}

export interface INotAuthUserInfo extends IBlackboxNotAuthUserInfo {
    authorizePath: string;
    avatarPath: string;
    passportPath: string;
    yu: string;
    geoLocation?: IGeoLocation;
    plusInfo?: IUserPlusInfo;
    /**
     * Гражданство, указано в code2 формате
     * @example KZ
     */
    citizenship?: string;
}

export interface IAuthUserInfo
    extends Omit<INotAuthUserInfo, 'isYandexNetwork'>,
        IBlackboxAuthUserInfo {}

export type TUserInfo = INotAuthUserInfo | IAuthUserInfo;

export interface IEnvironmentConfig {
    secureIFramePath: string;
    uxfeedbackIframeSrc: string;
    csrfTokenValidTill: number | null;
    tld: TLD;
}

export interface ICommonReducer {
    deviceType: IDevice;
    userInfo: TUserInfo;
    userUnreadMailCount: number;
    previousSearchForm: IPreviousSearchFormStore;
    features: FeaturesState;
    environmentConfig: IEnvironmentConfig;
    currencies: ICurrenciesStore;
    orderAuthorization: IOrderAuthorization;
    userSplit: IUserSplit;
    csrfToken: ICSRFToken;
    experiments: TExperiments;
    time: number;
    nonce: string;
    goals: TMetrikaGoal[];
    banners: IBannersState;
    countries: CountriesStateType;
    togglers: TCommonTogglersStore;
    passengers: IPassengersReducer;
    crossLinks: ICrossLinksState;
    hotelsGeolocationErrorModal: IHotelsGeolocationErrorModal;
    isBot: boolean;
    page: IPageInfo;
    snackbar: ISnackbarState;
    subscription: TSubscriptionStore;
    appVersion: IAppVersion;
    /** Признак, что запрос пришел с домена типа xredirect.yandex.ru */
    isFromXredirect: boolean;
    isNetworkOnline: boolean;
    whiteLabelConfig: IWhiteLabelConfig | null;
}
