import {ICountry} from 'types/common/ICountry';

import sortBy from 'utilities/sortBy/sortBy';

// Данные для сортировки первых 4-х стран
const SPEC_VALUES: Record<number, number> = {
    225: 4, // Россия
    187: 3, // Украина
    149: 2, // Беларусь
    159: 1, // Казахстан
};

// В первую очередь страны из константы
const compareBySpec = (a: ICountry, b: ICountry) => {
    const x = SPEC_VALUES[a.geoId] || 0;
    const y = SPEC_VALUES[b.geoId] || 0;
    if (x > y) return -1;
    if (x < y) return 1;
    return 0;
};

// Сравнение по название
const compareByTitle = (a: ICountry, b: ICountry) => {
    if (a.title > b.title) return 1;
    if (a.title < b.title) return -1;
    return 0;
};

export default (data: ICountry[]) =>
    data.slice().sort(sortBy(compareBySpec).thenBy(compareByTitle));
