import {ActionType, createAction, createAsyncAction} from 'typesafe-actions';

import {
    ICrossLinksActionsRequestPayload,
    ICrossLinksActionSuccessPayload,
    ICrossLinksActionFailurePayload,
} from './types';

/* Actions */
export const fetchCrossLinksActions = createAsyncAction(
    'common/crossLinks/fetch',
    'common/crossLinks/fetchSuccess',
    'common/crossLinks/fetchError',
)<
    ICrossLinksActionsRequestPayload,
    ICrossLinksActionSuccessPayload,
    ICrossLinksActionFailurePayload
>();

export const resetCrossLinks = createAction(
    'common/crossLinks/reset',
)<undefined>();

/* Action Types */
export type TFetchCrossLinksActionTypes =
    | typeof fetchCrossLinksActions
    | typeof resetCrossLinks;

export type TCrossLinksActionTypes = ActionType<TFetchCrossLinksActionTypes>;
