import {createReducer} from 'typesafe-actions';

import {EProjectName} from 'constants/common';

import {ICrossLinksApiResponse} from 'server/api/CommonApi/types/CrossLinks';

import {
    TCrossLinksActionTypes,
    fetchCrossLinksActions,
    resetCrossLinks,
} from './actions';

const initialState = {
    isFetched: false,
    isLoading: false,
    response: {
        crossLinks: [],
        recipes: {directions: []},
    },
    project: null,
};

export interface ICrossLinksState {
    isFetched: boolean;
    isLoading: boolean;
    response: ICrossLinksApiResponse;
    project: EProjectName | null;
}

/* Reducer */
export default createReducer<ICrossLinksState, TCrossLinksActionTypes>(
    initialState,
)
    .handleAction(
        fetchCrossLinksActions.request,
        (state, {payload: {project}}) => ({
            ...initialState,
            project,
            isLoading: true,
        }),
    )
    .handleAction(fetchCrossLinksActions.success, (state, {payload}) => {
        const {response, project} = payload;

        return {
            ...state,
            response,
            project,
            isFetched: true,
            isLoading: false,
        };
    })
    .handleAction(fetchCrossLinksActions.failure, (state, {payload}) => ({
        ...initialState,
        project: payload.project,
    }))
    .handleAction(resetCrossLinks, () => ({...initialState}));
