import {EProjectName} from 'constants/common';

import {Request} from '@yandex-data-ui/core/lib/types';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {fetchCrossLinksActions} from 'reducers/common/crossLinks/actions';

import {commonService} from 'serviceProvider';

export const fetchCrossLinks =
    (type: EProjectName, req?: Request): CustomThunkAction<Promise<void>> =>
    async (dispatch): Promise<void> => {
        try {
            dispatch(fetchCrossLinksActions.request({project: type}));

            const response = await commonService
                .provider(req?.container)
                .getCrossLinks({type});

            dispatch(fetchCrossLinksActions.success({response, project: type}));
        } catch (e) {
            dispatch(fetchCrossLinksActions.failure({project: type}));
        }
    };
