import {getType} from 'typesafe-actions';

import {ProjectAction} from 'reducers/storeTypes';

import {fetchTokenAction} from './actions';

export interface ICSRFToken {
    value?: string;
}

/* Initial State */

const initialState: ICSRFToken = {};

/* Reducer */

export default (
    state: ICSRFToken = initialState,
    action: ProjectAction,
): ICSRFToken => {
    switch (action.type) {
        case getType(fetchTokenAction): {
            const {payload} = action;

            if (payload) {
                return {
                    ...state,
                    value: payload,
                };
            }

            return state;
        }

        default: {
            return state;
        }
    }
};
