import {createReducer} from 'typesafe-actions';

import {IUATraits} from 'types/common/IUATraits';

import {IDevice} from 'reducers/common/commonReducerTypes';
import {
    setDeviceTypeAction,
    TDeviceTypeActions,
} from 'reducers/common/deviceType/actions';

import isIE from 'server/utilities/isIE';

const INITIAL_STATE: IDevice = {
    isDesktop: true,
    isMobile: false,
    isTouch: false,
    isIe: false,
    os: {
        name: '',
        version: '',
    },
    browser: {
        name: '',
        version: '',
    },
};

const prepareDeviceTypeResponse = (response: IUATraits): IDevice => {
    if (!response) {
        return INITIAL_STATE;
    }

    const {
        isMobile,
        isTouch,
        OSFamily,
        OSVersion,
        BrowserName,
        BrowserVersion,
    } = response;

    return {
        isMobile,
        isTouch,
        isDesktop: !isMobile,
        isIe: isIE(response),
        os: {
            name: OSFamily,
            version: OSVersion,
        },
        browser: {
            name: BrowserName,
            version: BrowserVersion,
        },
    };
};

export default createReducer<IDevice, TDeviceTypeActions>(
    INITIAL_STATE,
).handleAction(setDeviceTypeAction, (state, {payload}) =>
    prepareDeviceTypeResponse(payload),
);
