import {createReducer, ActionType} from 'typesafe-actions';

import * as actions from 'reducers/common/page/actions';

export interface IPageInfo {
    /**
     * Первая страница на которую попал пользователь
     */
    entry: Nullable<string>;
}

const INITIAL_STATE: IPageInfo = {
    entry: null,
};

export default createReducer<IPageInfo, ActionType<typeof actions>>(
    INITIAL_STATE,
).handleAction(actions.setEntryPage, (state, {payload}) => ({
    ...state,
    entry: payload,
}));
