import {createAsyncAction, ActionType} from 'typesafe-actions';

import {IPassengerWithDocumentsDTO} from 'server/api/TravelersApi/types/IPassengerDTO';

import {EPassengersActionType} from './actionTypes';

/* Actions */

export const fetchPassengersActions = createAsyncAction(
    EPassengersActionType.fetchPassengers,
    EPassengersActionType.fetchPassengersSuccess,
    EPassengersActionType.fetchPassengersFail,
)<undefined, IPassengerWithDocumentsDTO[], undefined>();

/* Action Types */

export type TPassengersActionsTypes = ActionType<typeof fetchPassengersActions>;
