import {createReducer} from 'typesafe-actions';

import {IPassengerWithDocumentsDTO} from 'server/api/TravelersApi/types/IPassengerDTO';

import {TPassengersActionsTypes, fetchPassengersActions} from './actions';

export interface IPassengersReducer {
    isLoading: boolean;
    isSuccess: boolean;
    isFailed: boolean;
    data: IPassengerWithDocumentsDTO[];
}

const initialState: IPassengersReducer = {
    isLoading: false,
    isSuccess: false,
    isFailed: false,
    data: [],
};

export default createReducer<IPassengersReducer, TPassengersActionsTypes>(
    initialState,
)
    .handleAction(fetchPassengersActions.request, () => ({
        isLoading: true,
        isSuccess: false,
        isFailed: false,
        data: [],
    }))
    .handleAction(fetchPassengersActions.success, (_, {payload}) => ({
        isLoading: false,
        isSuccess: true,
        isFailed: false,
        data: payload,
    }))
    .handleAction(fetchPassengersActions.failure, () => ({
        isLoading: false,
        isSuccess: false,
        isFailed: true,
        data: [],
    }));
