import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {isAuthUser} from 'utilities/userInfo/isAuthUser';

import {accountService} from 'serviceProvider';

import {fetchPassengersActions} from './actions';

export const fetchPassengers =
    (): CustomThunkAction<void> =>
    async (dispatch, getState): Promise<void> => {
        const userInfo = getState().common.userInfo;
        const isAuth = isAuthUser(userInfo);

        if (!isAuth) {
            return;
        }

        dispatch(fetchPassengersActions.request());

        try {
            const passengers = await accountService
                .provider()
                .getPassengersWithDocuments();

            dispatch(fetchPassengersActions.success(passengers));
        } catch {
            dispatch(fetchPassengersActions.failure());
        }
    };
