import {createReducer, ActionType} from 'typesafe-actions';

import {
    AVIA_SEARCH_FORM_NAME,
    RAILWAYS_SEARCH_FORM_NAME,
    HOTELS_SEARCH_FORM_NAME,
    BUSES_SEARCH_FORM_NAME,
} from 'constants/reduxForm';

import {IPreviousSearchFormStore} from './types';
import {IAviaSuggest} from 'types/avia/suggests/IAviaSuggest';
import {ITrainsSuggest} from 'types/trains/common/ITrainsApiSuggest';
import {IHotelsSuggest} from 'types/hotels/common/ISearchSuggest';
import {IBusesSuggest} from 'types/buses/common/IBusesSuggest';

import * as actions from './actions';
import {defaultFormValue} from './consts';

const INITIAL_STATE: IPreviousSearchFormStore = {
    [AVIA_SEARCH_FORM_NAME]: defaultFormValue<IAviaSuggest>(),
    [RAILWAYS_SEARCH_FORM_NAME]: defaultFormValue<ITrainsSuggest>(),
    [HOTELS_SEARCH_FORM_NAME]: defaultFormValue<IHotelsSuggest>(),
    [BUSES_SEARCH_FORM_NAME]: defaultFormValue<IBusesSuggest>(),
};

export default createReducer<
    IPreviousSearchFormStore,
    ActionType<typeof actions>
>(INITIAL_STATE).handleAction(
    actions.previousSearchFormSetPreparedForms,
    (state, {payload}) => payload.preparedForms,
);
