import {
    AVIA_SEARCH_FORM_NAME,
    BUSES_SEARCH_FORM_NAME,
    HOTELS_SEARCH_FORM_NAME,
    RAILWAYS_SEARCH_FORM_NAME,
    TOURS_SEARCH_FROM_NAME,
} from 'constants/reduxForm';

import {ESearchFormFieldName} from 'components/SearchForm/types';
import {IAviaSuggest} from 'types/avia/suggests/IAviaSuggest';
import {ITrainsSuggest} from 'types/trains/common/ITrainsApiSuggest';
import {IHotelsSuggest} from 'types/hotels/common/ISearchSuggest';
import {IBusesSuggest} from 'types/buses/common/IBusesSuggest';
import {IToursSuggestBase} from 'projects/index/IndexApp/components/IndexTours/components/SearchForm/types';

import {IBaseSuggestItem} from 'components/SearchSuggest/SearchSuggest';

export interface IPreviousFormFieldValue {
    type?: string;
    title?: string;
    countryTitle?: string;
    pointKey?: string;
    objId?: string;
    objType?: string;
    name?: string;
    description?: string;
}
export type TPreviousFormValue<T extends IBaseSuggestItem> = {
    from: (IPreviousFormFieldValue & T)[];
    to: (IPreviousFormFieldValue & T)[];
};

export interface IPreviousSearchFormStore {
    [AVIA_SEARCH_FORM_NAME]?: TPreviousFormValue<IAviaSuggest>;
    [RAILWAYS_SEARCH_FORM_NAME]?: TPreviousFormValue<ITrainsSuggest>;
    [HOTELS_SEARCH_FORM_NAME]?: TPreviousFormValue<IHotelsSuggest>;
    [BUSES_SEARCH_FORM_NAME]?: TPreviousFormValue<IBusesSuggest>;
    [TOURS_SEARCH_FROM_NAME]?: TPreviousFormValue<IToursSuggestBase>;
}

export interface IPreviousSearchFormSetFieldValuePayload {
    fieldType: ESearchFormFieldName.FROM | ESearchFormFieldName.TO;
    // Тут выходят какие-то сложные дженерики, поэтому пока оставим any
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    fieldValue: any;
    uniqueValueName: string;
    formName: keyof IPreviousSearchFormStore;
}
