import {combineReducers} from 'redux';

import {ELoadableReducer} from 'types/common/ELoadableReducer';

import timeReducer from 'reducers/common/time/reducer';
import loadableReducer from 'reducers/utils/loadableReducers/loadableReducer';

import bannersReducer from './banners/reducer';
import goalsReducer from './goals/reducer';
import deviceTypeReducer from './deviceType/reducer';
import userInfoReducer from './userInfo/reducer';
import previousSearchFormReducer from './previousSearchForm/reducer';
import featuresReducer from './features/reducer';
import environmentConfigReducer from './environmentConfig/reducer';
import currencyReducer from './currencies/reducer';
import countriesReducer from './countries/reducer';
import checkOrderAuthorizationReducer from './checkOrderAuthorization/reducer';
import csrfTokenReducer from './csrfToken/reducer';
import experimentsReducer from './experiments/reducer';
import userSplitReducer from './userSplit/reducer';
import userUnreadMailCountReducer from './userUnreadMailCount/reducer';
import nonceReducer from './nonce/reducer';
import togglersReducer from './togglers/reducer';
import passengersReducer from './passengers/reducer';
import hotelsGeolocationErrorModalReducer from './hotelsGeolocationErrorModal/reducer';
import isBotReducer from './isBot/reducer';
import pageReducer from './page/reducer';
import snackbarReducer from './snackbar/reducer';
import subscriptionReducer from './subscription/rootReducer';
import appVersionReducer from './appVersion/reducer';
import isFromXredirectReducer from './isFromXredirect/reducer';
import isNetworkOnlineReducer from './isNetworkOnline/reducer';
import whiteLabelConfigReducer from './whiteLabelConfig/reducer';

export default combineReducers({
    banners: bannersReducer,
    goals: goalsReducer,
    deviceType: deviceTypeReducer,
    userInfo: userInfoReducer,
    userUnreadMailCount: userUnreadMailCountReducer,
    previousSearchForm: previousSearchFormReducer,
    features: featuresReducer,
    environmentConfig: environmentConfigReducer,
    currencies: currencyReducer,
    countries: countriesReducer,
    orderAuthorization: checkOrderAuthorizationReducer,
    experiments: experimentsReducer,
    userSplit: userSplitReducer,
    csrfToken: csrfTokenReducer,
    time: timeReducer,
    nonce: nonceReducer,
    togglers: togglersReducer,
    passengers: passengersReducer,
    crossLinks: loadableReducer(ELoadableReducer.COMMON_CROSSLINKS),
    hotelsGeolocationErrorModal: hotelsGeolocationErrorModalReducer,
    isBot: isBotReducer,
    page: pageReducer,
    snackbar: snackbarReducer,
    subscription: subscriptionReducer,
    appVersion: appVersionReducer,
    isFromXredirect: isFromXredirectReducer,
    isNetworkOnline: isNetworkOnlineReducer,
    whiteLabelConfig: whiteLabelConfigReducer,
});
