import {ActionType, createReducer} from 'typesafe-actions';

import {IPromoCodeForSubscription} from 'server/api/NotifierApi/types';
import {ESubscriptionVerticalName} from 'types/subscription/ESubscriptionVerticalName';

import * as actions from 'reducers/common/subscription/promoCodeInfo/actions';

import {getNow} from 'utilities/dateUtils';

interface ISubscriptionConfigRecord {
    data: Nullable<IPromoCodeForSubscription>;
    timestamp: number;
}

export type TSubscriptionConfigState = Partial<
    Record<ESubscriptionVerticalName, ISubscriptionConfigRecord>
>;

const INITIAL_STATE: TSubscriptionConfigState = {};

export default createReducer<
    TSubscriptionConfigState,
    ActionType<typeof actions>
>(INITIAL_STATE).handleAction(
    actions.setSubscriptionConfig,
    (state, {payload: [vertical, {promoCode}]}): TSubscriptionConfigState => ({
        ...state,
        [vertical]: {
            data: promoCode,
            timestamp: getNow(),
        },
    }),
);
