import moment from 'moment-timezone';

import {DEFAULT_LANGUAGE_RU} from 'constants/common';

import {ESubscriptionCode} from 'types/subscription/ESubscriptionCode';
import {ESubscriptionSource} from 'types/subscription/ESubscriptionSource';
import {ESubscriptionVerticalName} from 'types/subscription/ESubscriptionVerticalName';

import {notifierService} from 'serviceProvider';

interface ISubscribeParams {
    email: string;
    promoSubscriptionCode: ESubscriptionCode;
    source: ESubscriptionSource;
    travelVerticalName: ESubscriptionVerticalName;
}

/** Не работает на сервере, нужно докинуть req.container в провайдер */
export async function subscribeOnPromo({
    email,
    ...rest
}: ISubscribeParams): Promise<void> {
    await notifierService.provider().subscribe({
        email,
        timezone: moment.tz.guess(),
        language: DEFAULT_LANGUAGE_RU,
        nationalVersion: DEFAULT_LANGUAGE_RU,
        ...rest,
    });
}
