import {ActionType, createReducer} from 'typesafe-actions';

import * as actions from './actions';

export interface ISubscriptionState {
    /**
     * TODO:
     * Сейчас описывает только начально состояние подписки.
     * Если менять этот флаг по время пользовательской сессии, то будут неприятные эффекты с исчезновение блока.
     * Надо сделать так, чтобы флаг описывал актуальное состояние, без таких эффектов.
     */
    isSubscribed: boolean;
    isFetched: boolean;
}

const INITIAL_STATE: ISubscriptionState = {
    isSubscribed: false,
    isFetched: false,
};

export default createReducer<ISubscriptionState, ActionType<typeof actions>>(
    INITIAL_STATE,
).handleAction(
    actions.setSubscribedStatus,
    (state, {payload: isSubscribed}): ISubscriptionState => ({
        ...state,
        isSubscribed,
        isFetched: true,
    }),
);
