import {ActionType, createAction} from 'typesafe-actions';

import {EToggler} from 'types/common/togglers/EToggler';
import {TCommonTogglersStore} from 'types/common/togglers/TCommonTogglersStore';

export const setToggler = createAction('COMMON.TOGGLERS.SET_TOGGLER')<{
    togglerKey: EToggler;
    value: boolean;
}>();

export const setTogglers = createAction(
    'COMMON.TOGGLERS.SET',
)<TCommonTogglersStore>();

export type TCommonTogglersActions =
    | ActionType<typeof setToggler>
    | ActionType<typeof setTogglers>;
