import {createReducer} from 'typesafe-actions';

import {INITIAL_TOGGLERS_STORE} from 'constants/togglers';

import {TCommonTogglersStore} from 'types/common/togglers/TCommonTogglersStore';

import {
    setToggler,
    setTogglers,
    TCommonTogglersActions,
} from 'reducers/common/togglers/actions';

export default createReducer<TCommonTogglersStore, TCommonTogglersActions>(
    INITIAL_TOGGLERS_STORE,
)
    .handleAction(setTogglers, (state, {payload}) => payload)
    .handleAction(setToggler, (state, {payload}) => ({
        ...state,
        [payload.togglerKey]: payload.value,
    }));
