import {ActionType, createReducer} from 'typesafe-actions';

import * as actions from 'reducers/common/userInfo/actions';
import {TUserInfo} from 'reducers/common/commonReducerTypes';

const INITIAL_STATE: TUserInfo = {
    authorizePath: '',
    avatarPath: '',
    passportPath: '',
    yu: '',
};

export default createReducer<TUserInfo, ActionType<typeof actions>>(
    INITIAL_STATE,
)
    .handleAction(actions.setUserInfoAction, (state, {payload}) => ({
        ...payload.passportConfig,
        ...payload.userInfo,
        yu: payload.yu,
    }))
    .handleAction(actions.setUserGeoLocationAction, (state, {payload}) => ({
        ...state,
        geoLocation: payload,
    }))
    .handleAction(actions.setUserCitizenship, (state, {payload}) => ({
        ...state,
        citizenship: payload,
    }))
    .handleAction(actions.setUserPlusInfoAction, (state, {payload}) => ({
        ...state,
        plusInfo: {
            hasPlus: payload.hasPlus,
            points: payload.points,
        },
    }));
