import {createStore, applyMiddleware, compose} from 'redux';
import thunk from 'redux-thunk';

import createRootReducer from './rootReducer';

const reduxMiddlewares = [thunk];

export default () => {
    const store = createStore(
        createRootReducer(),
        {},
        compose(applyMiddleware(...reduxMiddlewares)),
    );

    store.refreshReducers = (): void => {
        store.replaceReducer(createRootReducer());
    };

    return store;
};
