import {createAction, createAsyncAction, ActionType} from 'typesafe-actions';

import IAddFavoriteHotelRequestParams from 'server/api/HotelsFavoritesAPI/types/IAddFavoriteHotelRequestParams';
import {
    IRemoveFavoriteHotelByPermalinkRequestParams,
    IRemoveFavoriteHotelsByCategoryIdRequestParams,
} from 'server/api/HotelsFavoritesAPI/types/IRemoveFavoriteHotelsRequestParams';
import IGetFavoriteHotelsRequestParams from 'server/api/HotelsFavoritesAPI/types/IGetFavoriteHotelsRequestParams';
import IGetFavoriteHotelsResponse from 'server/api/HotelsFavoritesAPI/types/IGetFavoriteHotelsResponse';
import IGetFavoriteHotelsOffersResponse from 'server/api/HotelsFavoritesAPI/types/IGetFavoriteHotelsOffersResponse';
import IGetSharedFavoriteHotelsResponse from 'server/api/HotelsFavoritesAPI/types/IGetSharedFavoriteHotelsResponse';
import IGetSharedFavoriteHotelsRequestParams from 'server/api/HotelsFavoritesAPI/types/IGetSharedFavoriteHotelsRequestParams';
import {PermalinkType} from 'types/hotels/hotel/IHotel';
import {IActiveHotel} from 'types/hotels/hotel/IActiveHotel';

import {HOTELS_FAVORITES_ACTION_TYPES} from './actionTypes';

/* Добавление отеля в избранное */
export const addFavoriteHotelAction = createAction(
    HOTELS_FAVORITES_ACTION_TYPES.ADD_FAVORITE_HOTEL,
)<IAddFavoriteHotelRequestParams>();

export type AddFavoriteHotelActionType = typeof addFavoriteHotelAction;

/* Удаление отеля из избранного */
export const removeFavoriteHotelAction = createAction(
    HOTELS_FAVORITES_ACTION_TYPES.REMOVE_FAVORITE_HOTEL,
)<IRemoveFavoriteHotelByPermalinkRequestParams>();

export type RemoveFavoriteHotelActionType = typeof removeFavoriteHotelAction;

/* Изменение "избранности" отеля */
export const changeHotelsIsFavoriteActions = createAsyncAction(
    HOTELS_FAVORITES_ACTION_TYPES.START_CHANGE_HOTELS_IS_FAVORITE_REACTION_REQUEST,
    HOTELS_FAVORITES_ACTION_TYPES.SUCCESS_CHANGE_HOTELS_IS_FAVORITE_REACTION_REQUEST,
    HOTELS_FAVORITES_ACTION_TYPES.FAILED_CHANGE_HOTELS_IS_FAVORITE_REACTION_REQUEST,
)<
    | IAddFavoriteHotelRequestParams
    | IRemoveFavoriteHotelByPermalinkRequestParams,
    PermalinkType,
    undefined
>();

export type ChangeHotelsIsFavoriteActionsType = ActionType<
    typeof changeHotelsIsFavoriteActions
>;

/* Получение списка избранных отелей и категорий */
export const getFavoritesInfoActions = createAsyncAction(
    HOTELS_FAVORITES_ACTION_TYPES.START_GET_FAVORITES_INFO_REQUEST,
    HOTELS_FAVORITES_ACTION_TYPES.SUCCESS_GET_FAVORITES_INFO_REQUEST,
    HOTELS_FAVORITES_ACTION_TYPES.FAILED_GET_FAVORITES_INFO_REQUEST,
)<IGetFavoriteHotelsRequestParams, IGetFavoriteHotelsResponse, undefined>();

export type GetFavoritesInfoActionsType = ActionType<
    typeof getFavoritesInfoActions
>;

/* Получение списка избранных отелей выбранной категории */
export const getSharedFavoriteHotelsActions = createAsyncAction(
    HOTELS_FAVORITES_ACTION_TYPES.START_GET_SHARED_FAVORITES_HOTELS_REQUEST,
    HOTELS_FAVORITES_ACTION_TYPES.SUCCESS_GET_SHARED_FAVORITES_HOTELS_REQUEST,
    HOTELS_FAVORITES_ACTION_TYPES.FAILED_GET_SHARED_FAVORITES_HOTELS_REQUEST,
)<
    IGetSharedFavoriteHotelsRequestParams,
    IGetSharedFavoriteHotelsResponse,
    undefined
>();

export type GetSharedFavoriteHotelsActionsType = ActionType<
    typeof getSharedFavoriteHotelsActions
>;

/* Изменение выбранной категории избранного */
export const changeFavoriteCategoryAction = createAction(
    HOTELS_FAVORITES_ACTION_TYPES.CHANGE_FAVORITE_CATEGORY,
)<string | null>();

export type ChangeFavoriteCategoryActionType = ActionType<
    typeof changeFavoriteCategoryAction
>;

/* Start Polling Epoch */
export const pollingHotelsOffersActions = createAsyncAction(
    HOTELS_FAVORITES_ACTION_TYPES.START_POLLING_HOTELS_OFFERS,
    HOTELS_FAVORITES_ACTION_TYPES.SUCCESS_POLLING_HOTELS_OFFERS,
    HOTELS_FAVORITES_ACTION_TYPES.FAILED_POLLING_HOTELS_OFFERS,
)<PermalinkType[], IGetFavoriteHotelsOffersResponse, undefined>();

export type PollingHotelsOffersActionsType = ActionType<
    typeof pollingHotelsOffersActions
>;

/* Stop Polling Epoch */
export const stopPollingHotelsOffersAction = createAction(
    HOTELS_FAVORITES_ACTION_TYPES.STOP_POLLING_HOTELS_OFFERS,
)<undefined>();

export type StopPollingHotelsOffersActionType =
    typeof stopPollingHotelsOffersAction;

/* Пагинация */
export const changeFavoriteHotelsOffsetAction = createAction(
    HOTELS_FAVORITES_ACTION_TYPES.CHANGE_FAVORITE_HOTELS_OFFSET,
)<number>();

export type ChangeFavoriteHotelsOffsetActionType = ActionType<
    typeof changeFavoriteHotelsOffsetAction
>;

/* Форма поиска */
export const setCheckinDateAction = createAction(
    HOTELS_FAVORITES_ACTION_TYPES.SET_CHECKIN_DATE,
)<string>();

export type SetCheckinDateActionType = ActionType<typeof setCheckinDateAction>;

export const setCheckoutDateAction = createAction(
    HOTELS_FAVORITES_ACTION_TYPES.SET_CHECKOUT_DATE,
)<string>();

export type SetCheckoutDateActionType = ActionType<
    typeof setCheckoutDateAction
>;

export const setAdultsAction = createAction(
    HOTELS_FAVORITES_ACTION_TYPES.SET_ADULTS,
)<number>();

export type SetAdultsActionType = ActionType<typeof setAdultsAction>;

export const setChildrenAgesAction = createAction(
    HOTELS_FAVORITES_ACTION_TYPES.SET_CHILDREN_AGES,
)<number[]>();

export type SetChildrenAgesActionType = ActionType<
    typeof setChildrenAgesAction
>;

/* Удаление категории */
export const removeFavoriteHotelsAction = createAction(
    HOTELS_FAVORITES_ACTION_TYPES.REMOVE_FAVORITE_HOTELS,
)<IRemoveFavoriteHotelsByCategoryIdRequestParams>();

export type RemoveFavoriteHotelsActionType = typeof removeFavoriteHotelsAction;

export const setShareTokenAction = createAction(
    HOTELS_FAVORITES_ACTION_TYPES.SET_SHARE_TOKEN_ACTION,
)<string>();

export type SetShareTokenActionType = ActionType<typeof setShareTokenAction>;

/* Hover карточки отеля */
export const setDefaultActiveHotel = createAction(
    HOTELS_FAVORITES_ACTION_TYPES.SET_DEFAULT_ACTIVE_HOTEL,
)<IActiveHotel | void>();

export const setActiveHotel = createAction(
    HOTELS_FAVORITES_ACTION_TYPES.SET_ACTIVE_HOTEL,
)<IActiveHotel | void>();

// Экшен напрямую не изменяет стор
// Нужен для отложенного восстановления дефолтного выделения отеля
// Отложенное восстановление выделения чтоб не моргали отели/пины
// когда мы переводим курсор с одного отеля на другой
export const resetActiveHotel = createAction(
    HOTELS_FAVORITES_ACTION_TYPES.RESET_ACTIVE_HOTEL,
)<undefined>();

export type SetDefaultActiveHotelActionType = ActionType<
    typeof setDefaultActiveHotel
>;

export type SetActiveHotelActionType = ActionType<typeof setActiveHotel>;

export type FavoritesActionsTypes =
    | GetFavoritesInfoActionsType
    | GetSharedFavoriteHotelsActionsType
    | ChangeFavoriteCategoryActionType
    | PollingHotelsOffersActionsType
    | ChangeFavoriteHotelsOffsetActionType
    | SetCheckinDateActionType
    | SetCheckoutDateActionType
    | SetAdultsActionType
    | SetChildrenAgesActionType
    | ChangeHotelsIsFavoriteActionsType
    | SetShareTokenActionType
    | SetDefaultActiveHotelActionType
    | SetActiveHotelActionType;
