import {ActionType, createAction, createAsyncAction} from 'typesafe-actions';

import {IGetOrderHappyPageServiceParams} from 'server/services/OrdersService/types/IGetOrderHappyPageServiceParams';
import {THappyPageOrderInfo} from 'types/happyPage/THappyPageOrderInfo';
import {IErrorResponse} from 'types/common/IErrorResponse';
import {IGenericOrderInfo} from 'server/api/GenericOrderApi/types/common/IGenericOrderInfo';

export const getHappyPageActions = createAsyncAction(
    'HAPPY_PAGE.REQUEST',
    'HAPPY_PAGE.REQUEST_SUCCESS',
    'HAPPY_PAGE.REQUEST_FAILURE',
)<IGetOrderHappyPageServiceParams, THappyPageOrderInfo, IErrorResponse>();

export const updateHappyPageGenericOrderAction = createAction(
    'HAPPY_PAGE.UPDATE_GENERIC_ORDER',
)<IGenericOrderInfo>();

const reducerActions = {
    ...getHappyPageActions,
    updateHappyPageGenericOrderAction,
};

export type THappyPageActions = ActionType<typeof reducerActions>;

export type TGetHappyPageRequestAction = (
    params: IGetOrderHappyPageServiceParams,
) => void;
