import {createReducer} from 'typesafe-actions';

import {IHappyPageStore} from 'reducers/happyPage/types/IHappyPageStore';
import {EOrderApiType} from 'server/api/OrdersAPI/enums/types';

import {
    getHappyPageActions,
    THappyPageActions,
    updateHappyPageGenericOrderAction,
} from 'reducers/happyPage/actions';

const INITIAL_STATE: IHappyPageStore = {
    value: null,
    isLoading: false,
    isFetched: false,
    isFailed: false,
    errorResponse: undefined,
};

export default createReducer<IHappyPageStore, THappyPageActions>(INITIAL_STATE)
    .handleAction(getHappyPageActions.request, () => ({
        ...INITIAL_STATE,
        isLoading: true,
    }))
    .handleAction(getHappyPageActions.success, (state, {payload}) => ({
        ...state,
        value: payload,
        isLoading: false,
        isFetched: true,
    }))
    .handleAction(getHappyPageActions.failure, (state, {payload}) => ({
        ...state,
        value: null,
        isLoading: false,
        isFetched: true,
        isFailed: true,
        errorResponse: payload,
    }))
    .handleAction(updateHappyPageGenericOrderAction, (state, {payload}) => {
        const orderInfo = state.value;

        if (!orderInfo || orderInfo.orderType !== EOrderApiType.BUS) {
            return state;
        }

        return {
            ...state,
            value: {
                ...orderInfo,
                order: payload,
            },
        };
    });
