import {ISearchInformation} from 'reducers/hotels/searchInformation/types';
import {IHotelsSearchFormValues} from 'projects/hotels/components/SearchForm/types';

import {ILegacyHotelInfoReducer} from 'reducers/hotels/legacyHotelPage/reducer';
import {IBookAndPayReducer} from 'reducers/hotels/bookAndPayPage/IBookAndPayReducer';
import {IHotelsSearchPageReducer} from 'reducers/hotels/searchPage/IHotelsSearchPageReducer';
import {IHotelsHotelPageReducer} from 'reducers/hotels/hotelPage/IHotelsHotelPageReducer';
import {IGeoRegionInfoReducer} from 'reducers/hotels/geoRegionPage/reducer';
import {ISearchSuggest} from 'reducers/hotels/searchSuggests/reducer';
import {IWelcomePromocodeReducer} from 'reducers/hotels/welcomePromocode/reducer';
import {IHotelsPreviousSearchesStore} from 'reducers/hotels/previousSearches/reducer';
import {IHotelPersonalization} from 'reducers/hotels/personalization/reducer';

export interface IHotelsStore {
    searchForm: IHotelsSearchFormValues;
    searchSuggests: ISearchSuggest;
    legacyHotelPage: ILegacyHotelInfoReducer;
    bookAndPay: IBookAndPayReducer;
    searchHotelsPage: IHotelsSearchPageReducer;
    hotelPage: IHotelsHotelPageReducer;
    searchInformation: ISearchInformation;
    geoRegionPage: IGeoRegionInfoReducer;
    welcomePromocode: IWelcomePromocodeReducer;
    previousSearches: IHotelsPreviousSearchesStore;
    personalization: IHotelPersonalization;
}
