import {createAsyncAction, createAction, ActionType} from 'typesafe-actions';

import {IFetchBookOfferParams} from 'server/api/HotelsBookAPI/types/IBookOffer';
import {IFetchOfferResponse, TOfferInfoByTokenFailedPayload} from './types';

import {OFFER_INFO_BY_TOKEN} from './actionTypes';

/* Actions */

export const fetchOfferInfoByTokenAction = createAsyncAction(
    OFFER_INFO_BY_TOKEN.FETCH_OFFER_INFO,
    OFFER_INFO_BY_TOKEN.FETCH_OFFER_INFO_SUCCESS,
    OFFER_INFO_BY_TOKEN.FETCH_OFFER_INFO_FAIL,
)<IFetchBookOfferParams, IFetchOfferResponse, TOfferInfoByTokenFailedPayload>();

export const resetOfferInfoAction = createAction(
    OFFER_INFO_BY_TOKEN.RESET_OFFER_INFO,
)();

export const updateOfferInfoAction = createAction(
    OFFER_INFO_BY_TOKEN.UPDATE_OFFER_INFO,
)<IFetchOfferResponse>();

/* ActionTypes */

export type TFetchOfferInfoByToken = (params: IFetchBookOfferParams) => void;

export type TOfferInfoByTokenActionTypes =
    | ActionType<typeof fetchOfferInfoByTokenAction>
    | ActionType<typeof resetOfferInfoAction>
    | ActionType<typeof updateOfferInfoAction>;
