import {createAsyncAction, ActionType, createAction} from 'typesafe-actions';

import {IOrderRefundableInfo} from 'server/api/HotelsBookAPI/types/IOrderRefundableInfo';

import {
    FETCH_REFUNDABLE_INFO,
    FETCH_REFUNDABLE_INFO_SUCCESS,
    FETCH_REFUNDABLE_INFO_ERROR,
    CANCEL_ORDER,
    CANCEL_ORDER_SUCCESS,
    CANCEL_ORDER_ERROR,
    SET_IS_REFUNDABLE_MODAL_VISIBLE,
} from './actionTypes';

/* Fetch Refundable Info */

type OrderIdType = string;

export const fetchRefundableInfoActions = createAsyncAction(
    FETCH_REFUNDABLE_INFO,
    FETCH_REFUNDABLE_INFO_SUCCESS,
    FETCH_REFUNDABLE_INFO_ERROR,
)<OrderIdType, IOrderRefundableInfo, undefined>();

export type FetchRefundableInfoActionsType = ActionType<
    typeof fetchRefundableInfoActions
>;

export type FetchRefundableInfoActionType = (
    payload: OrderIdType,
) => FetchRefundableInfoActionsType;

/* Start Cancel */

export interface ICancelOrderPayload {
    orderId: OrderIdType;
    refundToken: string;
}

export const startCancelOrderActions = createAsyncAction(
    CANCEL_ORDER,
    CANCEL_ORDER_SUCCESS,
    CANCEL_ORDER_ERROR,
)<ICancelOrderPayload, undefined, undefined>();

export type StartCancelOrderActionsType = ActionType<
    typeof startCancelOrderActions
>;

export const setRefundModalVisible = createAction(
    SET_IS_REFUNDABLE_MODAL_VISIBLE,
)<boolean>();

export type SetRefundModalVisibleActionType = ActionType<
    typeof setRefundModalVisible
>;

export type StartCancelOrderActionType = (
    payload: ICancelOrderPayload,
) => StartCancelOrderActionsType;
